/* DO NOT EDIT THIS FILE */
/* This file is autogenerated by the text-database code generator */

#include <fonts/CachedFont.hpp>

namespace touchgfx
{
const uint8_t* CachedFont::getPixelData(const GlyphNode* glyph) const
{
    // If glyph is cached, then data is present just after the GlyphNode
    if (FontCache::isCached(glyph))
    {
        const uint8_t* data = FontCache::getPixelData(glyph);
        return data;
    }
    return flashFont->getPixelData(glyph);
}

const GlyphNode* CachedFont::getGlyph(Unicode::UnicodeChar unicode, const uint8_t*& pixelData, uint8_t& bitsPerPixel) const
{
    // Look first in internal flash font
    const GlyphNode* n = flashFont->find(unicode);

    if ((n == 0) && (cache != 0))
    {
        // Now look in FontCache table
        n = cache->getGlyph(unicode, fontId);
    }

    // Revert to normal behaviour if still not found
    if (n == 0 && unicode != 0 && unicode != '\n')
    {
        Unicode::UnicodeChar fallbackChar = flashFont->getFallbackChar();
        n = flashFont->find(fallbackChar);
        if (n == 0)
        {
            n = cache->getGlyph(fallbackChar, fontId);
        }
    }

    if (n != 0)
    {
        pixelData = getPixelData(n);
        bitsPerPixel = getBitsPerPixel();
        return n;
    }
    return (const GlyphNode*)0;
}

int8_t CachedFont::getKerning(Unicode::UnicodeChar prevChar, const GlyphNode* glyph) const
{
    // Kerning is not supported by Font Caching
    return 0;
}
} // namespace touchgfx
